ftrack
======

ftrack is the project management, production tracking and media review platform that teams in the creative industries use to collaborate. ftrack connects people, simplifies workflows and increases studio efficiency.

Introduction
------------

This chart bootstraps ftrack deployment on a [Kubernetes](http://kubernetes.io) cluster using the [Helm](https://helm.sh) package manager.

Prerequisites
-------------

-	Kubernetes cluster
-	PV network storage support or storage mounted on each node for cluster setup.
-   Helm 3

Before installing the chart you need to create a yaml configuration file with the following content
(can ignore the "database.port" setting below if planning to run the db on the default port):

```yaml
secret: A-RANDOM-STRING

config:
  ftrack.server_url: http://YOUR-SERVER-URL

database:
  host: IP-ADDRESS-OF-MARIADB
  port: PORT-OF-MARIADB

imageRegistry:
    username: YOUR-DOCKERHUB-USERNAME
    password: YOUR_DOCKERHUB_PASSWORD

localPersistentVolume:
    path: /ftrack/data

```

You also need to install (and configure) MariaDB either on the same server or on another server:

```bash
# Install MariaDB 10.3.
# https://downloads.mariadb.org/mariadb/repositories/#mirror=lund&distro=CentOS&distro_release=centos7-amd64--centos7&version=10.3
yum install MariaDB-server MariaDB-client

# Start MariaDB.
systemctl start mariadb
systemctl enable mariadb

# Configure MariaDB (add "-P YOUR_DESIRED_PORT" to commands below if you have configured a custom port).
/usr/bin/mysqladmin -u root password 'rootpass'
mysql -u root -prootpass -e 'create database ftrack'
mysql -u root -prootpass -e 'grant all privileges on ftrack.* to "ftrack_user"@"localhost" identified by "ftrack_pass"'
mysql -u root -prootpass -e 'grant SUPER on *.* to "ftrack_user"@"localhost"'
mysql -u root -prootpass -e 'grant all privileges on ftrack.* to "ftrack_user"@"%" identified by "ftrack_pass"'
mysql -u root -prootpass -e 'grant SUPER on *.* to "ftrack_user"@"%"'

# Add default database.
curl -o /tmp/database.sql https://s3-eu-west-1.amazonaws.com/ftrack-deployment/localinstall/backups/workflows/database.sql
mysql --user=ftrack_user --password=ftrack_pass ftrack < /tmp/database.sql

```

Storage
-------

The ftrack service require a place to store files that are uploaded to the
server. This storage can either be using a mount point available on the servers
running ftrack or using a network-attached storage using NFS (recommended).

To use mount points on the servers, add the following to the config:

```yaml
localPersistentVolume:
    path: /ftrack/data
```

To use a network-attached storage via NFS, add the following config but replace
NFS-SERVER-IP and /STORAGE/PATH with details from your storage:

```yaml
nfsPersistentVolume:
    enabled: true
    path: /STORAGE/PATH
    server: NFS-SERVER-IP
    size: 100Gi
```

On the storage you selected an attachments folder and tmp folder must be
created with full permissions. If the path to the storage is /ftrack/data the
following can be used:

```bash
mkdir /ftrack /ftrack/data /ftrack/data/attachments /ftrack/data/tmp
chmod -R 777 /ftrack/data/*
```

Installing the Chart
--------------------

helm install --values config.yaml --debug ftrack ftrack-helm.tar.gz

Uninstalling the Chart
----------------------

Assuming your release is named as `my-release`, delete it using the command:

```bash
$ helm delete my-release
```